package examples;

import java.util.Properties;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class LoanRatesClient {

     public static void main(String[] args) throws RemoteException, CreateException, NamingException {
         
          Properties env = new Properties();
          env.put("java.naming.factory.initial","com.sun.jndi.cosnaming.CNCtxFactory");
          env.put("java.naming.provider.url", "iiop://localhost:3700");
          InitialContext ctxt = new InitialContext(env);

          Object objRef = ctxt.lookup("LoanRatesBean");
		
          LoanRatesHome home = (LoanRatesHome) PortableRemoteObject.narrow(objRef, LoanRatesHome.class);

          LoanRates loanRatesObj = (LoanRates) PortableRemoteObject.narrow(home.create(), LoanRates.class);
          System.out.println("getHomeEquityRate() returned: " + loanRatesObj.getHomeEquityRate() + ". Take a look at application server log or console for messages from LoanRatesEJB and OutboundLoanRA.");
     }
}