package examples.out_loan_ra;

import java.util.*;

import javax.resource.cci.*;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.*;
import javax.resource.NotSupportedException;

public class ConnectionImpl implements javax.resource.cci.Connection {

     private ManagedConnectionImpl manConn;

     ConnectionImpl(ManagedConnectionImpl manConn) {

          System.out.println("ConnectionImpl(ManagedConnectionImpl) called");

          this.manConn = manConn;
     }
       
     public Interaction createInteraction() throws ResourceException {

          return new InteractionImpl(this);
     }
 
     public javax.resource.cci.LocalTransaction getLocalTransaction() throws ResourceException {

          throw new NotSupportedException("Local transactions are not supported.");
     }

     public ResultSetInfo getResultSetInfo() throws ResourceException {

          throw new NotSupportedException("ResultSet records are not supported.");
     }

     public void close() throws ResourceException {

          System.out.println("ConnectionImpl.close() called");      

          if (manConn == null) 
               return;

          manConn.sendEvent(ConnectionEvent.CONNECTION_CLOSED, null, this);

          manConn = null;
     }

     public ConnectionMetaData getMetaData() throws ResourceException {

          return new ConnectionMetaDataImpl(manConn);
     }
}