package examples.out_loan_ra;

import examples.jni.JavaLoanApp;

import java.util.*;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.IllegalStateException;
import javax.resource.cci.*;
import java.lang.reflect.*;
import java.lang.*;

public class InteractionImpl implements Interaction {

     Connection conn = null;
	
     public InteractionImpl(Connection conn) {

          System.out.println("InteractionImpl(Connection conn) called");

          this.conn = conn;
     }
    
     public javax.resource.cci.Connection getConnection() {

          return conn;
     }

     public void close() throws ResourceException {

          conn = null;
     }

     public boolean execute (InteractionSpec iSpec, Record in, Record out) throws ResourceException {

          System.out.println ("InteractionImpl.execute(InteractionSpec iSpec, Record in, Record out) called");

          out = exec((MappedRecord)in,(MappedRecord)out);

          if (out != null) {

               return true;
          } else {

               return false;
          }
     }

     public Record execute (InteractionSpec iSpec, Record in) throws ResourceException {

          System.out.println ("InteractionImpl.execute(InteractionSpec iSpec, Record in) called");

          MappedRecord out = new MappedRecordImpl();

          return exec((MappedRecord)in, out);
     }

     Record exec(MappedRecord in, MappedRecord out) throws ResourceException {

          try {

               System.out.println("InteractionImpl.exec(MappedRecord in, MappedRecord out) called");
               
               Set keys = in.keySet();
               Iterator iterator = keys.iterator();

               while (iterator.hasNext()) {

                    String key = (String)iterator.next();

                    if (key.equalsIgnoreCase("HomeEquityRate")) {

                         JavaLoanApp jlaObj = new JavaLoanApp("C:\\LoanApp.dll");
                         float equityRate = jlaObj.getHomeEquityLoanRate();
                         System.out.println ("JNI Call Returned: " + equityRate);
                         out.put(key, new Float(equityRate));
                    }
               }
               
               return out;	
          }
          catch(Exception e) {
          
               throw new ResourceException(e.getMessage());		
          }
     }

     public ResourceWarning getWarnings() throws ResourceException {

          return null;
     }

     public void clearWarnings() throws ResourceException {

     }
}