package examples.out_loan_ra;

import java.io.*;
import java.util.*;

import javax.resource.*;
import javax.resource.spi.*;
import javax.resource.spi.security.PasswordCredential;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.naming.Context;
import javax.naming.InitialContext;

public class ManagedConnectionFactoryImpl implements ManagedConnectionFactory, Serializable {

     private PrintWriter manConnLogWriter;

     public ManagedConnectionFactoryImpl() {
     
          System.out.println("ManagedConnectionFactoryImpl() called");
     }

     public Object createConnectionFactory(ConnectionManager connManager) throws ResourceException {

          System.out.println("ManagedConnectionFactoryImpl.createConnectionFactory(ConnectionManager) called");

          return new ConnectionFactoryImpl(this, connManager);
     }

     public Object createConnectionFactory() throws ResourceException {
          throw new ResourceException ("How can you call this method in a managed environment?");
     }


     public ManagedConnection createManagedConnection (Subject subject, ConnectionRequestInfo connRequestInfo) {

          System.out.println ("ManagedConnectionFactoryImpl.createManagedConnection (Subject, ConnectionRequestInfo) called");

          return new ManagedConnectionImpl (this);
     }


     public ManagedConnection matchManagedConnections(Set connSet, Subject subject, ConnectionRequestInfo connRequestInfo) 
          throws ResourceException {

          System.out.println("ManagedConnectionFactoryImpl.matchManagedConnections(Set, Subject, ConnectionRequestInfo) called");

          Iterator iterator = connSet.iterator();

          while (iterator.hasNext()) {

               Object object = iterator.next();

               if (object instanceof ManagedConnectionImpl) {

                    ManagedConnectionImpl manConn = (ManagedConnectionImpl) object;
                    ManagedConnectionFactory manConnFactory = manConn.getManagedConnectionFactory();

                    if (manConnFactory.equals(this)) {

                         System.out.println("From ManagedConnectionFactoryImpl.matchManagedConnections() -> Connection matched");

                         return manConn;
                    }
               }
          }

          System.out.println("From ManagedConnectionFactoryImpl.matchManagedConnections() -> Connection did not match");

          return null;
     }

     public void setLogWriter(PrintWriter manConnLogWriter) {

          this.manConnLogWriter = manConnLogWriter;
     }

     public PrintWriter getLogWriter() {

          return manConnLogWriter;
     }

     public boolean equals(Object object) {

          if (object == null) return false;

          if (object instanceof ManagedConnectionFactoryImpl) {

               return true;
          } else {

               return false;
          }
     }

     public int hashCode() {
          
          return (new String("ManagedConnectionFactoryImpl")).hashCode();
     }
}