package examples.out_loan_ra;

import java.io.*;

import javax.resource.Referenceable;
import javax.resource.*;
import javax.resource.spi.*;
import javax.naming.Reference;
import javax.resource.cci.*;

public class ResourceAdapterMetaDataImpl implements ResourceAdapterMetaData {

     private String adapterName;
     private String adapterShortDescription;
     private String adapterVendorName;
     private String adapterVersion;
     private String[] interactionSpecsSupported;
     private String specVersion;
     private boolean supportsExecuteWithInputAndOutputRecord;
     private boolean supportsExecuteWithInputRecordOnly;
     private boolean supportsLocalTransactionDemarcation;

     // Additional properties
     private boolean supportsGlobalTransactions;
     private boolean supportsLifecycleManagement;
     private boolean supportsMessageInflow;
     private boolean supportsTransactionInflow;
     private boolean supportsConnectionManagement;
     private boolean supportsSecurityManagement;

     public ResourceAdapterMetaDataImpl() {

          adapterName = "Loan Application Resource Adapter";
          adapterShortDescription = "Loan Application Resource Adapter provides connectivity to Loan Application DLL";
          adapterVendorName = "Connectors Inc.";
          adapterVersion = "1.0";
          interactionSpecsSupported[0] = "InteractionImpl";
          specVersion = "1.5";
          supportsExecuteWithInputAndOutputRecord = true;
          supportsExecuteWithInputRecordOnly = true;
          supportsLocalTransactionDemarcation = false;
          supportsGlobalTransactions = false;
          supportsLifecycleManagement = false;
          supportsMessageInflow = false;
          supportsTransactionInflow = false;
          supportsConnectionManagement = true;
          supportsSecurityManagement = false;
     }

     public String getAdapterName() {

          return adapterName;
     }

     public String getAdapterShortDescription() {

          return adapterShortDescription;
     }

     public String getAdapterVendorName() {

          return adapterVendorName;
     }

     public String getAdapterVersion() {

          return adapterVersion;
     }

     public String[] getInteractionSpecsSupported() {

          return interactionSpecsSupported;
     }

     public String getSpecVersion() {

          return specVersion;
     }

     public boolean supportsExecuteWithInputAndOutputRecord() {

          return supportsExecuteWithInputAndOutputRecord;
     }

     public boolean supportsExecuteWithInputRecordOnly() {

          return supportsExecuteWithInputRecordOnly;
     }

     public boolean supportsLocalTransactionDemarcation() {

          return supportsLocalTransactionDemarcation;
     }

     public boolean supportsGlobalTransactions() {

          return supportsGlobalTransactions;
     }

     public boolean supportsLifecycleManagement() {

          return supportsLifecycleManagement;
     }

     public boolean supportsMessageInflow() {

          return supportsMessageInflow;
     }

     public boolean supportsTransactionInflow() {

          return supportsTransactionInflow;
     }

     public boolean supportsConnectionManagement() {

          return supportsConnectionManagement;
     }

     public boolean supportsSecurityManagement() {

          return supportsSecurityManagement;
     }
}