package examples.security;

import java.io.*;
import java.util.*;
import javax.security.auth.login.*;
import javax.security.auth.*;
import javax.security.auth.callback.*;

/**
 * Implements the CallbackHandler that gathers uid/pw input from
 * System.in.
 */

public class CallbackHandler 
    implements javax.security.auth.callback.CallbackHandler 
{
    /**
     * @param callbacks an array of <code>Callback</code> objects
     *
     * @exception java.io.IOException 
     * @exception UnsupportedCallbackException if the  <code>callbacks</code> 
     *            parameter contains unknown callback objects
     */
    public void handle(Callback[] callbacks)
        throws IOException, UnsupportedCallbackException
    {      
        for (int i = 0; i < callbacks.length; i++) 
        {
	    if (callbacks[i] instanceof NameCallback) 
            { 
 		// prompt user for name
 		NameCallback nc = (NameCallback)callbacks[i];
 		System.out.print(nc.getPrompt());
                String name = 
                    (new BufferedReader(new InputStreamReader(System.in))).readLine();
 		nc.setName(name);
 	    } 
            else if (callbacks[i] instanceof PasswordCallback) 
            {
 		// prompt user for passeord
 		PasswordCallback pc = (PasswordCallback)callbacks[i];
 		System.out.print(pc.getPrompt());
                String pwLine = 
                    (new BufferedReader(new InputStreamReader(System.in))).readLine();
 		pc.setPassword( pwLine.toCharArray());
 	    } 
            else 
            {
 		throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
 	    }
	}
    }
}

