package examples.security;

import javax.ejb.SessionContext;

/**
 * Demonstration stateless session bean.
 *
 * @ejb.bean
 *     name="JAASHello"
 *     type="Stateless"
 *     jndi-name="JAASHelloHome"
 *
 * @ejb.interface
 *     remote-class="examples.security.Hello"
 *     local-class="examples.security.HelloLocal"
 *
 * @ejb.home
 *     remote-class="examples.security.HelloHome"
 *     local-class="examples.security.HelloLocalHome"
 *
 */
public class HelloBean implements javax.ejb.SessionBean
{
    private SessionContext ctx = null;

    //
    // EJB-required methods
    //
    public void ejbCreate()
    {
        System.out.println("ejbCreate()");
    }

    public void ejbRemove()
    {
        System.out.println("ejbRemove()");
    }

    public void ejbActivate()
    {
        System.out.println("ejbActivate()");
    }

    public void ejbPassivate()
    {
        System.out.println("ejbPassivate()");
    }

    public void setSessionContext(SessionContext ctx)
    {
        this.ctx = ctx;
        System.out.println("setSessionContext()");
    }

    //
    // Business methods
    //
    /**
     * @ejb.permission
     *   role-name=testrole
     */

    public String hello()
    {
        System.out.println("Security principal is:");
        System.out.println(ctx.getCallerPrincipal().getName());
        System.out.println("hello()");
        return "Hello, World!";
    }
}
