package examples.security;

import java.util.*;
import javax.security.auth.*;
import javax.security.auth.login.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;

/** 
 * A client program that uses JAAS to authenticate 
 */ 
public class HelloClient 
{
    public static void main(String[] args) 
    {        
        try 
        {
            /* Authenticate via JAAS */
            LoginContext loginContext = 
                new LoginContext("HelloClient", new CallbackHandler());
            loginContext.login();
             
            /* Get a bean */
            Context ctx = new InitialContext(System.getProperties());
            Object obj = ctx.lookup("JAASHelloHome");
            HelloHome home = 
                (HelloHome)PortableRemoteObject.narrow(obj, HelloHome.class);
            Hello hello = home.create();
            
            /* Call a business method, propagating the security context */
            String result = hello.hello();

            /* Print the return result from the business logic */
            System.out.println(result);            
        }
        catch (Exception e) 
        {
            e.printStackTrace();
        }        
    }
}
