package examples;

import java.util.Collection;
import java.rmi.RemoteException;
import java.util.*;

/**
 * This is the CartBean remote interface.
 *
 * This interface is what clients operate on when they interact with
 * EJB objects.  The container vendor will implement this interface;
 * the implemented object is the EJB object, which delegates
 * invocations to the actual bean.
 */
public interface Cart 
    extends javax.ejb.EJBObject 
{
    /**
     * Adds an item to the shopping cart
     */
    public void add(LineItem lineItem) throws RemoteException;
    
    /**
     * Changes the quantities of contents in the shopping cart
     */
    public void modify(String productID, int quantity) 
        throws Exception, RemoteException;

    /**
     * Returns all the shopping cart line items
     *
     * @return A collection of Cart LineItems
     */
    public Vector getAll() throws RemoteException;

    /**
     * Empties the shopping cart
     */
    public void clear() throws RemoteException;

    /**
     * Get/set methods for the shopping cart owner's name
     */
    public String getOwner() throws RemoteException;
    public void setOwner(String owner) throws RemoteException;

    /**
     * Purchases this cart.  The cart will create
     * an order in the database.
     *
     * @return The Order confirmation number
     */
    public String purchase() throws RemoteException;    
    
   /**
    * Returns the subtotal price which has been
    * previously set by setSubtotal().
    * @return the subtotal of this cart items.
    */ 
    public double getSubtotal() throws RemoteException;

   /**
    * Sets the subtotal price.
    * Our external pricer bean is responsible for
    * calculating the subtotal.  It calculates it
    * based upon customer discounts (and can be
    * extended to include other rules as well).
    */
    public void setSubtotal(double subTotal) throws RemoteException;
    
  /**
   * Returns the taxes for this Quote.
   */
    public double getTaxes() throws RemoteException;
    
    /**
     * Sets the taxes for this Quote.
     */
    public void setTaxes(double taxes) throws RemoteException;
    
    /**
     * Returns the total price.  Total Price is computed from:
     * 1) Subtotal price
     * 2) Tax
     */	
    public double getTotalPrice() throws RemoteException;
   

}
