package examples;

import javax.ejb.*;
import java.rmi.RemoteException;
import java.rmi.Remote;
import java.util.*;

/**
 * This is the Catalog remote interface.
 *
 * This interface is what clients operate on when
 * they interact with EJB objects.  The container
 * vendor will implement this interface; the
 * implemented object is the EJB object, which
 * delegates invocations to the actual bean.
 */
public interface Catalog extends EJBObject {
	/**
     * Returns a list of productitems
     */
    public Vector getProductItemList()throws RemoteException;
    /**
     * Returns a productitem for the given product id.
     */
    public ProductItem getProductItem(String productId) throws RemoteException;
        
}


