package examples;

import javax.ejb.*;
import java.rmi.RemoteException;
import java.util.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;

/**
 * This catalog Stateless Session Bean retrieves a list of productitems.
 * ProductItem has product Id, name of the product and description
 */
public class CatalogBean 
    implements SessionBean 
{    
    private static final String productHomeName = "java:comp/env/ejb/ProductHome";

    /*
     * Although this is a stateless session bean, we
     * do have state - the session context.  Remember
     * that stateless session beans can store state, they
     * just can't store state on behalf of particular
     * clients.
     */
    private SessionContext ctx;

    //----------------------------------------------------
    // End EJB-required methods
    //----------------------------------------------------
    
    /**
     * Returns the productitem for the given product id
     */
    public ProductItem getProductItem(String productId)
    {
        try
        {            
            Context ctx = new InitialContext();
            ProductHome productHome = 
                (ProductHome)PortableRemoteObject.narrow(
                       ctx.lookup(productHomeName), ProductHome.class);

            Product product = productHome.findByPrimaryKey(productId);

            /*
             * Creates and returns the product item
             */
            return new ProductItem(product.getProductID(),
                                   product.getName(),
                                   product.getBasePrice(),
                                   product.getDescription());
        }
        catch (Exception e) 
        {
            throw new EJBException(e);
        }
    }
    
    /**
     * Returns the list of productitems
     */ 
    public Vector getProductItemList()
    {
        try
        {
            Context ctx = new InitialContext();
            ProductHome productHome = 
                (ProductHome)PortableRemoteObject.narrow(
                        ctx.lookup(productHomeName), ProductHome.class);
            Collection products = productHome.findAllProducts();
            Enumeration items = Collections.enumeration(products);
            Vector productItems = new Vector();
            while (items.hasMoreElements()) 
            {
                Product product= (Product)items.nextElement();
                /*
                 * Creates a new productitem
                 */
                ProductItem p = new ProductItem(product.getProductID(),
                                                product.getName(),
                                                product.getBasePrice(),
                                                product.getDescription());
                productItems.add(p);
            }
            /*
             * Returns the vector of product items
             */
            return productItems;
        }
        catch (Exception e) 
        {
            throw new EJBException(e);
        }
    }
        
    //----------------------------------------------------
    // Begin EJB-required methods.  The methods below are
    // called by the Container, and never called by client
    // code.
    //----------------------------------------------------
   
    public void ejbCreate() throws RemoteException {
        System.out.println("ejbCreate() called.");
    }
  
    public void ejbRemove() {
        System.out.println("ejbRemove() called.");
    }

    public void ejbActivate() {
        System.out.println("ejbActivate() called.");
    }

    public void ejbPassivate() {
        System.out.println("ejbPassivate() called.");
    }
   
    /**
     * Associates this Bean instance with a particular
     * context.
     */
    public void setSessionContext(SessionContext ctx) 
    {
        System.out.println("setSessionContext() called");
        this.ctx = ctx;
    }

}
