package examples;

import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

/**
 * Sample test client for our E-Commerce beans
 */
public class Client 
{
    public static void main(String args[]) 
        throws Exception 
    {
        Context ctx = new InitialContext(System.getProperties());        
        CustomerHome customerHome = 
            (CustomerHome)PortableRemoteObject.narrow(
                ctx.lookup("CustomerHome"), CustomerHome.class);
       
        Customer c = 
            customerHome.create(generatePK(), "Ed Roman", "edPass", "Austin TX");
    }
    
    /**
     * Generates a primary key
     */
    private static String generatePK() throws Exception 
    {
        String pk = new Long(System.currentTimeMillis()).toString();        
        synchronized (pk) {
            Thread.sleep(100);
        }       
        return pk;
    }
}
