package examples;

import javax.ejb.*;
import javax.naming.*;
import java.rmi.*;
import javax.rmi.PortableRemoteObject;
import java.util.*;

/**
 * Client test application
 */
public class CustomerClient 
{
    public static void main(String[] args) 
    {
        CustomerHome home = null;

        try {
            /*
             * Get a reference to the Home Object - the
             * factory for EJB Objects
             */
            Context ctx = new InitialContext(System.getProperties());
            Object obj = ctx.lookup("CustomerHome");
            home = (CustomerHome)
                PortableRemoteObject.narrow(obj, CustomerHome.class);

            /*
             * Use the factory to create EJB Objects
             */
            home.create("123-456-7890", "Bob", "bobPassword", "123 Oak St");
            home.create("123-456-7891", "Dan", "danPassword", "456 Pine St");
            home.create("123-456-7892", "Fred", "fredPassword", "456 Pine St");

            /*
             * Find a bean, and print out it's description
             */
            Collection c = home.findByAddress("456 Pine St");
            Iterator i = c.iterator();
            System.out.println("The following customers live at 456 Pine St:");
            while (i.hasNext()) {
                Customer customer = (Customer)
                    PortableRemoteObject.narrow(i.next(), Customer.class);
                System.out.println(customer.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally 
        {
            if (home != null) 
            {
                try 
                {
                    System.out.println("Destroying customers..");
                    /*
                     * Find all the customers
                     */
                    Iterator i = home.findAllCustomers().iterator();
                    while (i.hasNext()) 
                    {
                        try 
                        {
                            Customer customer = (Customer)
                                PortableRemoteObject.narrow(i.next(), Customer.class);
                            if (customer.getCustomerID().toString().startsWith("123")) {
                                customer.remove();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
