package examples;

import java.sql.*;
import javax.naming.*;
import javax.ejb.*;
import java.util.*;
import java.rmi.RemoteException;
import javax.naming.*;

/**
 * A line item is a quantity of a single product.
 * Many line items together form an entire order or cart.
 */
public class LineItem 
    implements java.io.Serializable 
{    
    /*
     * ProductItem has product id, name of the product and description
     */
    public ProductItem productItem;
    /*
     * Number of items
     */
    public int quantity;
    /*
     * Amount of the discount for each item
     */
    public double discount;
        
    //------------------------------------------------
    // Begin business methods
    //------------------------------------------------

    /**
     * Constructor
     * @param productitem
     * @param number of items
     * @Param discount for each item 
     */
    public LineItem(ProductItem productItem, int quantity, double discount) 
    {
        System.out.println("LineItem(...) called");
        this.productItem = productItem;
        this.quantity = quantity;
        this.discount = discount;
    }
	
    /**
     * Constructor
     */
    public LineItem() {
        System.out.println("New LineItem created.");
    }
    
    /**
     * Returns the productitem.
     * productitem has product id, name of the product and description
     */
    public ProductItem getProductItem()  
    {
        System.out.println("LineItem.getProduct() called.");
        return productItem;
    }
    
    /**
     * sets the productitem.
     * productitem has product id, name of the product and description
     */
    public void setProduct(ProductItem productItem)  
    {
        System.out.println("LineItem.setProduct() called.");
        this.productItem = productItem;
    }

    /**
     * Returns the number of items.
     */
    public int getQuantity()  
    {
        System.out.println("LineItem.getQuantity() called.");
        return quantity;
    }
  
    /**
     * Sets the number of items.
     */
    public void setQuantity(int quantity)  
    {
        System.out.println("LineItem.setQuantity() called.");
        this.quantity = quantity;
    }
	
    /**
     * Returns the base price.  The base price is the
     * product's price times the quantity ordered.  This
     * figure does not take discounts into consideration.
     */
    public double getBasePrice()  
    {
        System.out.println("LineItem.getBasePrice() called.");
        return quantity * productItem.getBasePrice();
    }

    /**
     * Returns the discount that the customer gets on
     * this order.
     *
     * Note: The discount is a whole number, not
     *       a percentage discount.
     */
    public double getDiscount()  
    {
        System.out.println("LineItem.getDiscount() called.");
        return discount;
    }
    
    /**
     * Sets the discount that the customer gets on
     * this order.
     *
     * Note: The discount is a whole number, not
     *       a percentage discount.
     */
    public void setDiscount(double discount)  
    {
        System.out.println("LineItem.setDiscount(" + discount + ") called.");
        this.discount = discount;
    }
        
    //------------------------------------------------
    // End business methods
    //------------------------------------------------
}
