package examples;

import java.net.URL;
import javax.xml.rpc.Service;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Stub;
import javax.xml.namespace.QName;

/**
 * This class is an example of a standalon JAX-RPC client code which 
 * uses both the static stub and the dynamic proxy approach to get
 * a reference to the remote Web Service
 */
public class PricerClient 
{
    static String host = "localhost";
    static String serviceURL = "Pricer";    
    static String nameSpaceUri = "urn:examples";
    static String serviceName = "PricerService";    
    static String serviceEndpointAddress = "http://" + host + ":8080/" + serviceURL;

    public static void main(String[] args) 
        throws Exception 
    {        
        if( args.length == 2 )
        {
            host = args[0];
            serviceURL = args[1];
        }
        
        // the static stub approach
        PricerInterface pricer = getStaticStub();

        String user = "Ed Roman";

        System.out.println("Tax rate: " + pricer.getTaxRate());
        System.out.println("Discount for : " + user + " is " + 
                           pricer.getPersonalDiscountRate(user));

        System.out.println("Discount for 1 item (at $1000,- per piece) for Ed is " + 
                           pricer.getDiscount(1, 1000, user));

        System.out.println("Discount for 5 items (at $1000,- per piece) for Ed is " + 
                           pricer.getDiscount(5, 5000, user));

    }

    private static PricerInterface getStaticStub() 
    {
        Stub stub =
            (Stub)(new PricerService_Impl().getPricerInterfacePort());
        stub._setProperty(javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY,
                          serviceEndpointAddress);
        return (PricerInterface)stub;

    }
}
