package examples;

import java.sql.*;
import javax.naming.*;
import javax.ejb.*;
import java.util.*;
import java.rmi.RemoteException;
import javax.naming.*;

/**
 * A productitem is details about the product.
 * 
 */

public class ProductItem implements java.io.Serializable {
    
    /*
     * Base price of the product
     */
    private double basePrice;
    
    /*
     * Name of the product
     */
    private String name;
    
    /*
     * Description of the product
     */
    private String description;
    
    /*
     * Product id
     */
    private String productId;
    
    /**
     * Constructor
     * @param productid
     * @param name of the product
     * @param price of the product
     * @param description of the product
     */ 
    public ProductItem(String productId, String name, double price,String description) {
        System.out.println("ProductItem(...) called");
        this.productId = productId;
        this.basePrice = price;
        this.name = name;
        this.description=description;
	}
    
    /**
     * Returns the product id.
     */
    public String getProductID(){
        return productId;
    }
    
    /*
     * Sets the product id.
     */
    public void setProductID(String productId){
        this.productId=productId;
    }
  
    /**
     * Returns the name of the product.
     */
    public String getName(){
        return name;
    }
 
    /**
     * Sets the name of the product.
     */
    public void setName(String name){
        this.name=name;
    }
  
    /**
     * Returns the description of the product.
     */
    public String getDescription(){
        return description;
    }
    
    /**
     * Sets the description of the product.
     */
    public void setDescription(String description){
        this.description=description;
    }

    /**
     * Returns the base price of the product.
     */
    public double getBasePrice(){
        return basePrice;
    }
    
    /**
     * Sets the base price of the product.
     */
    public void setBasePrice(double price){
        this.basePrice=price;
    }
		
}
