package examples;

import javax.ejb.*;

/**
 * These are the business logic methods exposed publicly by CustomerBean.
 *
 * This interface is what local clients operate on when they interact with
 * beans. The container vendor will implement this interface; the
 * implementation object is called the EJB Local Object, which delegates
 * invocations to the actual bean.
 */
public interface Customer extends EJBLocalObject {

	
    /**
     * Returns the Id of the customer.
     */
	public String getCustomerID();
    
    /**
     * Returns the name of the customer.
     */
	public String getName();
    
    /**
     * Sets the name of the customer.
     */
	public void setName(String name);
     
    /**
     * Returns the password of the customer.
     */
	public String getPassword();
    
    /**
     * Sets the password of the customer.
     */
	public void setPassword(String password);
    
    /**
     * Returns the address of the customer.
     */
	public String getAddress();
   
    /**
     * Sets the address of the customer.
     */   
	public void setAddress(String address);
}
