
package examples;

import java.sql.*;
import javax.sql.DataSource;
import javax.naming.*;
import javax.ejb.*;
import java.util.*;

/**
 * This is a container-managed persistent entity bean that
 * represents customer details.
 */
public abstract class CustomerBean 
    implements EntityBean 
{
    
    protected EntityContext ctx;
    
    /**
     * Returns the Id of the customer
     */
    public abstract String getCustomerID();
    
    /**
     * Sets the id of the customer
     */
    public abstract void setCustomerID(String customerId);
    
    /**
     * Returns the name of the customer
     */
    public abstract String getName();
    
    /**
     * Sets the name of the customer
     */
    public abstract void setName(String name);
    
    /**
     * Returns the password of the customer
     */
    public abstract String getPassword();
    
    /**
     * Sets the password of the customer
     */
    public abstract void setPassword(String password);
    
    /**
     * Returns the address of the customer
     */
    public abstract String getAddress();
    
    /**
     * Sets the address of the customer
     */
    public abstract void setAddress(String address);
    

    public abstract void setOrder(Collection o);

    public abstract Collection getOrder();



    /**
     * Associates this Bean instance with a particular context.
     * Once done, we can query the Context for environment
     * info, such as Bean customizations via properties.
     */
    public void setEntityContext(EntityContext ctx) {
        System.out.println("Customer.setEntityContext called");
        this.ctx = ctx;
    }
    
    /**
     * Disassociates this Bean instance with a particular
     * context environment.
     */
    public void unsetEntityContext() {
        System.out.println("Customer.unsetEntityContext called");
        this.ctx = null; 
    }
    
    /**
     * Called directly after activating this bean instance.
     * You should acquire needed resources in this method.
     */
    public void ejbActivate() {
        System.out.println("Customer.ejbActivate() called.");
    }
    
    /**
     * Called directly before passivating this bean instance.
     * Release any resources you acquired in ejbActivate() in
     * this method.
     */
    public void ejbPassivate() {
        System.out.println("Customer.ejbPassivate () called.");
    }
    
    /**
     * Updates the database to reflect the current values of
     * this object.
     *
     * Since we're using Container-Managed Persistence, the
     * container-generated subclass will automatically save
     * our state.  We then do pre-processing here.
     */
    public void ejbStore() {
        System.out.println("Customer.ejbStore() called.");
    }
    
    /**
     * Updates this object to reflect any changes to the
     * database data.
     *
     * Since we're using Container-Managed Persistence, the 
     * container-generated subclass will automatically load
     * our state.  We then do post-processing here.
     */
    public void ejbLoad() {
        System.out.println("Customer.ejbLoad() called.");
    }
    
    /**
     * Called when new database data is created.
     *
     * When the client calls the Home Object's create() method,
     * the Home Object then calls this ejbCreate() method.
     *
     * We need to initialize our Bean's state with the parameters
     * passed from the client by calling our own abstract set
     * methods.  The Container can then inspect our Bean and
     * INSERT the corresponding database entries.
     */
    public String ejbCreate(String id, 
                            String name,  
                            String password,
                            String address)
        throws CreateException 
    {
        System.out.println("Customer.ejbCreate() called.");
        setCustomerID(id);
        setName(name);
        setAddress(address);
        setPassword(password);   
        
        /*
         * CMP entity beans' ejbCreate() always return null.
         * The ejbCreate() method has a non-void return signature so
         * that the ejbCreate() signature matches that of a
         * BMP entity bean, allowing you to create a BMP entity bean
         * that subclasses a CMP entity bean.
         */
        return null;
    }
    
    /**
     * The Container calls this after ejbCreate().  At this
     * point in time, the bean instance is associated with its
     * own EJB Object.  You can get a reference to that
     * EJB Object by querying the context.  You'd use that
     * EJB Object reference when calling  external code,
     * and you'd like to pass a reference to yourself.
     */
    public void ejbPostCreate(String id, 
                              String name, 
                              String password,
                              String address )
        throws CreateException 
    {
        System.out.println("Customer.ejbPostCreate() called.");
    }

    /**
     * Called before the container removes entity bean data
     * from the database.  Corresponds to when client calls
     * home.remove().
     */
    public void ejbRemove() throws RemoveException {
        System.out.println("Customer.ejbRemove() called.");
    }

}
