package examples;

import javax.ejb.*;
import java.util.Collection;

/**
 * This is the local home interface for our entity bean.
 * The container will implement this as the home object,
 * which serves as a factory for EJB Objects.
 */
public interface CustomerHome 
    extends EJBLocalHome 
{

    /*
     * This method creates the EJB Object.
     *
     * Notice that this create returns an
     * EJB Object, whereas the bean's ejbCreate returns a PK.
     * This is because the EJB Container is responsible
     * for generating the EJB Object, whereas the Bean
     * is responsible for initialization.
     *
     * @param id of the customer
     * @param name of the customer
     * @param password of the customer
     * @param address of the customer
     */
	 
    Customer create(String customerID, String name, String password, String address) 
        throws CreateException;
    
    // Finder methods, implemented by container due to CMP

    /**
     * Returns the customer local object.
     * @param customer id
     */
    public Customer findByPrimaryKey(String key) 
        throws FinderException;
    
    /**
     * Returns a collection of customer local objects for the given name
     * @param name of the customer
     */
    public Collection findByName(String name)
        throws FinderException;
     
    /**
     * Returns a collection of customer local objects for the given address
     * @param address of the customer
     */
    public Collection findByAddress(String address) 
        throws FinderException;
    
    /**
     * Returns  a collection all customer local objects.
     */
    public Collection findAllCustomers() 
        throws FinderException;

    // Home business method, independent of any particular instance
    //public double getTotalNumberOfCustomers();

}
