package examples;

import javax.ejb.*;
import java.util.*;

/**
 * These are the business logic methods exposed publicly
 * by OrderBean.
 *
 * This interface is used by local clients.  The container
 * generates the implementation, which is called the
 * EJB local object, which delegates invocations to the actual bean.
 */
public interface Order extends EJBLocalObject {

	public String getOrderID();

	/**
	 * Returns the set of Order Line Items which compose
	 * this Order.  Each Line Item represents a specific
	 * product and quantity ordered.
	 */
	public Collection getLineItems();
    
    /**
     * Sets the set of order line items
     */
	public void setLineItems(Collection lineItems);

	/**
	 * get/set methods for the customer who placed the order
	 */
	public Customer getCustomer();
	public void setCustomer(Customer customer);

	/**
	 * Returns the total price.
	 * Total Price = calculated sum of lineItem prices
	 */
	public double getTotalPrice();

	/**
	 * Retrieves the date this was ordered on.  Date is set
	 * automatically when new Order is created.
	 */
	public java.sql.Timestamp getOrderDate();
	public void setOrderDate(java.sql.Timestamp date);

	/**
	 * get/set methods for the order status 
	 */
	public String getStatus();
	public void setStatus(String status);
}