package examples;

import javax.ejb.*;
import java.util.*;

/**
 * This is the local home interface for Order.  The container
 * will generate the implementation, which is called the
 * local home object, which is a factory for EJB local objects.
 */
public interface OrderHome extends EJBLocalHome {

	/*
	 * This method creates the EJB Object.
	 *
	 * Notice that this create returns an
	 * EJB Object, whereas the bean's ejbCreate returns a PK.
	 * This is because the EJB Container is responsible
	 * for generating the EJB Object, whereas the Bean
	 * is responsible for initialization.
	 *
	 * @param orderID The unique ID of this order
	 * @param customer The customer who owns this order
	 * @param lineItems the contents of the order - this is
	 *        a collection of LineItem classes
	 *
	 * @return The newly created EJB Object.
	 */
	public Order create(String orderID, Customer customer, Collection lineItems) throws CreateException;
    
    /*
	 * This method creates the EJB Object.
	 *
     * @param orderID The unique ID of this order
	 * @param customerid The customerid of the customer who owns this order
	 * @param lineItems the contents of the order - this is
	 *        a collection of LineItem classes
	 *
	 * @return The newly created EJB Object.
	 */
    
	public Order create(String orderID, String customer, Collection lineItems) throws CreateException;
    
    /*
	 * This method creates the EJB Object.
	 *
     * @param orderID The unique ID of this order
	 * @param customerid The customerid of the customer who owns this order
	 * @param status status of this order
     * @param subTotal subtotal of this order
     * @param taxes taxes of this order
	 * @return The newly created EJB Object.
	 */
    public Order create(String orderID, String customerid, String status, double subTotal,double taxes) throws CreateException;
    
    /*
	 * This method creates the EJB Object.
	 *
     * @param orderID The unique ID of this order
	 * @param customer The customer who owns this order
	 * @param status status of this order
     * @param subTotal subtotal of this order
     * @param taxes taxes of this order
	 * @return The newly created EJB Object.
	 */
    public Order create(String orderID, Customer customer,String status, double subTotal,double taxes) throws CreateException;
    // Finder methods, implemented by container due to CMP
    
    /**
     * Returns an Order EJB object for the given order id
     * @param orderid
     */
	public Order findByPrimaryKey(String key) throws FinderException;
     
    /**
     * Returns a collection of Order EJB objects for the given customer EJB object
     * @param customer Customer EJB object
     */
	public Collection findByCustomer(Customer customer) throws FinderException;
    
    /**
     * Returns a collection of Order EJB objects for the given order date
     * @param date order date
     */
	public Collection findByDate(java.sql.Timestamp date) throws FinderException;
    
    /**
     * Returns a collection of Order EJB objects for the given status
     * @param status order status
     */
	public Collection findByStatus(String status) throws FinderException;
    
    /**
     * Returns All Order EJB objects.
     *
     */
	public Collection findAllOrders() throws FinderException;
}