
package examples;

import javax.ejb.*;

/**
 * These are the business logic methods exposed publicly
 * by OrderLineItemBean.
 *
 * This interface is what local clients operate on when they
 * interact with beans. The container vendor will
 * implement this interface; the implementation object
 * is called the EJB Local Object, which delegates
 * invocations to the actual bean.
 */
public interface OrderLineItem 
    extends EJBLocalObject 
{

    /**
     * Retunrs the Id of the customer.
     */       
    public String getOrderLineItemID();
    
    /**
     * Returns the Order entity bean that this line item is part of.
     */
    public Order getOrder();
    
    /**
     * Sets the Order entity bean that this line item is part of.
     */
    public void setOrder(Order o);

    /**
     * Returns the number of items
     */
    public int getQuantity();
    
    /**
     * Sets the number of items
     */
    public void setQuantity(int quantity);

    /**
     * Returns the product associated with order line item
     */
    public Product getProduct();
    
    /**
     * Sets the product associated with this order line item
     */
    public void setProduct(Product product);
        
    /*
     * Returns the discount of this product to be ordered
     */
    public double getDiscount();
    /*
     * Sets the discount of this product to be ordered
     */
    public void setDiscount(double discount);
}
