package examples;

import javax.naming.*;
import javax.ejb.*;
import java.util.*;

/**
 * This is a container-managed persistent entity bean.  It represents
 * an order line-item.  A line-item is an order for a quantity of a
 * single product.  Many line-items together form an entire order.
 */
public abstract class OrderLineItemBean 
    implements EntityBean 
{
    protected EntityContext ctx;

    //------------------------------------------------
    // Begin business methods
    //------------------------------------------------

    public OrderLineItemBean() 
    {
    }

    /*
     * The id number of this line item.  This is our
     * primary key as well.
     * Returns the id of the customer
     */
    public abstract String getOrderLineItemID();
    
    /**
     * Sets the id of the customer
     */
    public abstract void setOrderLineItemID(String id);

    /**
     * Returns the Order entity bean that this line item is part of.
     */
    public abstract Order getOrder();
    
    /**
     * Sets the Order entity bean that this line item is part of.
     */
    public abstract void setOrder(Order order);

    /**
     * The Product entity bean that has been purchased.
     */
    public abstract Product getProduct();
    
    /**
     * Sets the associated product EJB Object
     */
    
    public abstract void setProduct(Product product);

    /**
     * The quantity of this product to be ordered
     */
    public abstract int getQuantity();
    /**
     * Sets the number of items
     */
    public abstract void setQuantity(int quantity);	
	
    /*
     * The discount of this product to be ordered
     */
    public abstract double getDiscount();
    
    /**
     * Sets the discount of  this product
     */
    public abstract void setDiscount(double discount);	
	
    //------------------------------------------------
    // End business methods
    //------------------------------------------------

    //------------------------------------------------
    // Begin EJB-required methods.
    //------------------------------------------------

    /**
     * Associates this Bean instance with a particular context.  Once
     * done, we can query the Context for environment info, such as
     * Bean customizations via properties.
     */
    public void setEntityContext(EntityContext ctx) 
    {
        this.ctx = ctx;
    }

    /**
     * Disassociates this Bean instance with a particular context
     * environment.
     */
    public void unsetEntityContext() 
    {
        this.ctx = null; 
    }

    /**
     * Called directly after activating this bean instance.  You
     * should acquire needed resources in this method.
     */
    public void ejbActivate() 
    {
    }

    /**
     * Called directly before passivating this bean instance.  Release
     * any resources you acquired in ejbActivate() in this method.
     */
    public void ejbPassivate() 
    {
    }

    /**
     * Updates the database to reflect the current values of this
     * object.
     *
     * Since we're using Container-Managed Persistence, the Container
     * will automatically save our public container-managed fields
     * into the database.  We should perform any necessary
     * pre-processing here.
     */
    public void ejbStore() 
    {
    }

    /**
     * Updates this object to reflect any changes to the database
     * data.
     *
     * Since we're using Container-Managed Persistence, the Container
     * will automatically set our public fields to the correct values.
     * We then do post-processing here.
     */
    public void ejbLoad() 
    {
    }

    /**
     * Called when new database data is created.
     *
     * When the client calls the Home Object's create() method, the
     * Home Object then calls this ejbCreate() method.
     *
     * We need to initialize our Bean's container-managed fields with
     * the parameters passed from the client, so that the Container
     * can inspect our Bean and create the corresponding database
     * entries.
     */
    public String ejbCreate(String orderLineItemID, 
                            Order order,
                            Product product, 
                            int quantity, 
                            double discount) 
        throws CreateException 
    {
        System.out.println("OrderLineItem.ejbCreate(" + orderLineItemID + ") called.");

        setOrderLineItemID(orderLineItemID);
        setQuantity(quantity);
        setDiscount(discount);
        /*
         * CMP entity beans' ejbCreate() always return null.
         * The ejbCreate() method has a non-void return signature so
         * that the ejbCreate() signature matches that of a
         * BMP entity bean, allowing you to create a BMP entity bean
         * that subclasses a CMP entity bean.
         */
        return null;
    }

    /**
     * The Container calls this after ejbCreate().
     *
     * At this point in time, the bean instance is associated with its
     * own EJB Object.  You can get a reference to that EJB Object by
     * querying the context.  You'd use that EJB Object reference when
     * calling an external module, and you'd like to pass a reference
     * to yourself.
     */
    public void ejbPostCreate(String orderLineItemID, 
                              Order order, 
                              Product product, 
                              int quantity,
                              double discount) 
        throws CreateException 
    {
        System.out.println("OrderLineItem.ejbPostCreate() called");
        setProduct(product);
        setOrder(order);
		
    }

    /**
     * Called before the container removes entity bean data from the
     * database.  Corresponds to when client calls home.remove().
     */
    public void ejbRemove() 
    {
    }

    // No finder methods - they are implemented by Container

    //------------------------------------------------
    // End EJB-required methods
    //------------------------------------------------
}
