package examples;

import javax.ejb.*;
import java.util.*;

/**
 * This is the local home interface for OrderLineItem.
 * The container implements this interface; the
 * implementation object is called the Local Home Object,
 * and serves as a factory for EJB Local Objects.
 */
public interface OrderLineItemHome extends EJBLocalHome {

    /*
     * This method creates the EJB Object.
     *
     * Notice that the Home Interface returns an EJB
     * Object, whereas the Bean returns a PK.  This is
     * because the EJB Container is responsible for
     * generating the EJB Object, whereas the Bean is
     * responsible for initialization.
     *
     * @param orderLineItemID The line-item's unique ID
     * @param product The product this line-item represents
     * @param quantity The quantity of product in this line-item
     *
     * @return The newly created EJB Object.
     */
    public OrderLineItem create(String orderLineItemID, 
                                Order order, 
                                Product product, 
                                int quantity,
                                double discount) 
        throws CreateException;

    /*
     * Finder methods.  Locate existing entity bean data.
     */
    /**
     * Returns the orderlineitem EJB object for the given order line item id
     */
    public OrderLineItem findByPrimaryKey(String key) throws FinderException;
    
    /**
     * Returns the set of order line item EJB objects for the given order EJB object
     */
    /*
    public Collection findByOrder(Order order) throws FinderException;    
    */

    /**
     * Returns the set of order line item EJB objects for the given product EJB Object
     */
    public Collection findByProduct(Product product) throws FinderException;
    
    /**
     * Returns the all order line item EJB objects 
     */
    public Collection findAllOrderLineItems() throws FinderException;
}
