package examples;

import javax.ejb.*;
import javax.jms.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;

/**
 * This message-driven bean receives JMS messages
 * to process orders.  It then performs the order
 * processing.
 */
public class OrderProcessorBean 
    implements MessageDrivenBean, MessageListener 
{
    protected MessageDrivenContext ctx;

    /**
     * The one business method that message-driven beans have
     * Here we perform the actual order processing
     */
    public void onMessage(Message msg) 
    {
        TextMessage tm = (TextMessage) msg;
        try 
        {
            String orderID = tm.getText();
            System.out.println("Processing order " + orderID);      
            Context ctx = new InitialContext();
            OrderHome home = 
                (OrderHome)PortableRemoteObject.narrow(
                       ctx.lookup("java:comp/env/ejb/OrderHome"), OrderHome.class);

            Order order = home.findByPrimaryKey(orderID);

            /*
             * At this point, we could perform lots of tasks:
             *
             * - A call-out to a credit card company (perhaps through
             *   web services) to check the user's credit
             *   card rating and perform a debit.
             *
             * - Check the product inventory to ensure availability
             *
             * - Check the current backlog for shipping orders
             *
             * - Send an email confirmation
             *
             * In this example, we'll merely set the order status to
             * "approved".
             */
            order.setStatus("approved");
        }
        catch (Exception e) 
        {
            e.printStackTrace();
            throw new EJBException(e);
        }
    }

    /**
     * Associates this bean instance with a particular context.
     * We can query the Context for environment info.
     */
    public void setMessageDrivenContext(MessageDrivenContext ctx) {
        this.ctx = ctx;
    }

    /**
     * The container calls this method at the beginning of our
     * lifecycle.  We should do any necessary initialization.
     */
    public void ejbCreate() {
        System.err.println("ejbCreate()");
    }

    /**
     * The container calls this method prior to destroying the
     * bean.  We should do any necessary cleanup.
     */
    public void ejbRemove() {
        System.err.println("ejbRemove()");
    }
}
