package examples;

/**
 * This is the Pricer Web Service's remote interface (the service
 * endpoint interface)
 */
public interface PricerInterface 
    extends java.rmi.Remote
{
    /**
     * @return the applicable tax rate
     */
    double getTaxRate()
        throws java.rmi.RemoteException;

    /**
     * @return the current discount rate for buying lots of items
     */
    double getBulkDiscountRate() 
        throws java.rmi.RemoteException;

    /**
     * @return the discount rate for a given user in percent 
     */
    double getPersonalDiscountRate(String userName) 
        throws java.rmi.RemoteException;

    /**
     * This method computes the applicable discount in absolute
     * figure, based on bulk and personal discounts that may apply.
     * 
     * @param quantity the number of items that a user intends to buy
     * @param basePrice the overall, non-discounted volume of the
     *        purchase (individual price times quantity)
     * @param the user name
     * @return the subTotal for the line item after applying any
     *         applicable discounts, excluding taxes
     */
    double getDiscount(int quantity, double basePrice, String user)
        throws java.rmi.RemoteException;

}
