package examples;

import javax.ejb.*;

/**
 * These are the public business methods of ProductBean.
 *
 * This local interface is what local clients operate
 * on when they interact with our bean. The container
 * will implement this interface; the implemented object
 * is called the EJB local object, which delegates
 * invocations to instances of the entity bean class.
 */
public interface Product extends EJBLocalObject {
    
    /**
     * Returns the id of the product.
     */
    public String getProductID();
    
    /**
     * Returns the name of the product
     */
    public String getName();
    
    /**
     * Sets the name of the product
     */
    public void setName(String name);
    
    /**
     * Returns the description of the product
     */
    public String getDescription();
    
    /**
     * Sets the description of the product
     */
    public void setDescription(String description);
    
    /**
     * Returns the base price of the product
     */
    public double getBasePrice();
    
    /**
     * Sets the base price of the product
     */
    public void setBasePrice(double price);

}
