package examples;

import javax.ejb.*;
import java.util.*;

/**
 * Entity Bean which demonstrates Container-Managed persistence.
 *
 * This is a product that's persistent.  It has an ID #, a name,
 * a description, and a base price.
 */
public abstract class ProductBean 
    implements EntityBean 
{
    protected EntityContext ctx;

    public ProductBean() {
    }

    //-----------------------------------------------
    // Begin abstract get/set methods
    //-----------------------------------------------

   
    /**
     * Returns the name of the product
     */
    public abstract String getName();
    
    /**
     * Sets the name of the product
     */
    public abstract void setName(String name);
    
    /**
     * Returns the description of the product
     */
    public abstract String getDescription();
    
    /**
     * Sets the description of the product
     */
    public abstract void setDescription(String description);
    
    /**
     * Returns the base price of the product
     */
    public abstract double getBasePrice();	
    
    /**
     * Sets the base price of the product
     */
    public abstract void setBasePrice(double price);	
    
    /**
     * Returns the id of the product.
     */
    public abstract String getProductID();
    
    /**
     * Sets the id of the product.
     */
    public abstract void setProductID(String productID);

	
    /**
     * Returns set of the order line items EJB objects
     */
    public abstract Collection getLineItems();
    
    /**
     * Sets set of the order line items EJB objects
     */
    public abstract void setLineItems(Collection lineItems);



    //-----------------------------------------------
    // End abstract get/set methods
    //-----------------------------------------------
	
    //-----------------------------------------------
    // Begin EJB-required methods.  The methods below
    // are called by the Container, and never called
    // by client code.
    //-----------------------------------------------

    /**
     * Called by Container.
     * Implementation can acquire needed resources.
     */
    public void ejbActivate() {
        System.out.println("Product.ejbActivate() called.");
    }

    /**
     * EJB Container calls this method right before it
     * removes the Entity Bean from the database.
     * Corresponds to when client calls home.remove().
     */
    public void ejbRemove() {
        System.out.println("Product.ejbRemove() called.");
    }

    /**
     * Called by Container.
     * Releases held resources for passivation.
     */
    public void ejbPassivate() {
        System.out.println("Product.ejbPassivate () called.");
    }

    /**
     * Called from the Container.  Updates the entity bean
     * instance to reflect the current value stored in
     * the database.
     *
     * Since we're using Container-Managed Persistence, we
     * can leave this method blank.  The EJB Container will
     * automatically load us in the subclass.
     */
    public void ejbLoad() {
        System.out.println("Product.ejbLoad() called.");
    }

    /**
     * Called from the Container.  Updates the database to
     * reflect the current values of this in-memory Entity Bean
     * instance representation.
     *
     * Since we're using Container-Managed Persistence, we can
     * leave this method blank.  The EJB Container will
     * automatically save us in the subclass.
     */
    public void ejbStore() {
        System.out.println("Product.ejbStore() called.");
    }

    /**
     * Called by Container.  Associates this Bean instance with
     * a particular context.  Once done, we can query the
     * Context for environment info
     */
    public void setEntityContext(EntityContext ctx) {
        System.out.println("Product.setEntityContext called");
        this.ctx = ctx;
    }

    /**
     * Called by Container.  Disassociates this Bean instance
     * with a particular context environment.
     */
    public void unsetEntityContext() {
        System.out.println("Product.unsetEntityContext called");
        this.ctx = null; 
    }

    /**
     * Called after ejbCreate().  Now, the Bean can retrieve
     * its EJBObject from its context, and pass it as a 'this'
     * argument.
     */
    public void ejbPostCreate(String productID, String name, String description, double basePrice) {
        System.out.println("Product.ejbPostCreate() called");
    }

    /**
     * This is the initialization method that corresponds to the
     * create() method in the Home Interface.
     *
     * When the client calls the Home Object's create() method,
     * the Home Object then calls this ejbCreate() method.
     *
     * We need to initialize our Bean's fields with the
     * parameters passed from the client, so that the Container
     * can create the corresponding database entries in the
     * subclass after this method completes.
     */
    public String ejbCreate(String productID, String name, String description, double basePrice)
        throws CreateException 
    {
        System.out.println("Product.ejbCreate() called");

        setProductID(productID);
        setName(name);
        setDescription(description);
        setBasePrice(basePrice);

        /*
         * CMP entity beans' ejbCreate() always return null.
         * The ejbCreate() method has a non-void return signature so
         * that the ejbCreate() signature matches that of a
         * BMP entity bean, allowing you to create a BMP entity bean
         * that subclasses a CMP entity bean.
         */
        return null;
    }

    // No finder methods
    // (they are implemented by Container)

    //-----------------------------------------------
    // End EJB-required methods
    //-----------------------------------------------
}
