package examples;

import javax.ejb.*;
import java.util.Collection;

/**
 * This is the local home interface for Product.
 * This interface is implemented by the EJB container.
 * The implemented object is called the local home object,
 * and serves as a factory for EJB local objects.
 * 
 * One create() method is in this Home Interface, which
 * corresponds to the ejbCreate() method in the bean class.
 */
public interface ProductHome 
    extends EJBLocalHome 
{
	/*
	 * Creates a product
	 *
	 * @param productID The number of the product (unique)
	 * @param name The name of the product
	 * @param description Product description
	 * @param basePrice Base Price of product
	 *
	 * @return The newly created EJB Object.
	 */
	Product create(String productID, String name, String description, double basePrice) 
            throws CreateException;

	// Finder methods.  These are implemented by the
	// container.  You can customize the functionality of
	// these methods in the deployment descriptor through
	// EJB-QL and container tools.

	/**
     * Returns the product EJB object for the given product id
     */
    public Product findByPrimaryKey(String key) throws FinderException;

    /**
     * Returns set of the product EJB objects for the given product name
     */
	public Collection findByName(String name) throws FinderException;
    
    /**
     * Returns set of the product EJB objects for the given product description
     */
	public Collection findByDescription(String description) throws FinderException;
    
    /**
     * Returns set of the product EJB objects for the given product base price
     */
	public Collection findByBasePrice(double basePrice) throws FinderException;
    
    /**
     * Returns set of the product EJB objects whose base price is greater than minprice
     */
	public Collection findExpensiveProducts(double minPrice) throws FinderException;
    
     /**
     * Returns set of the product EJB objects whose base price is less than maxPrice
     */
	public Collection findCheapProducts(double maxPrice) throws FinderException;

    /**
     * Returns set of all the product EJB objects
     */
	public Collection findAllProducts() throws FinderException;
}
