package examples;

import javax.ejb.*;
import java.rmi.RemoteException;
import java.rmi.Remote;


/**
 * This is the UserManager remote interface.
 *
 * This interface is what clients operate on when
 * they interact with EJB objects.  The container
 * vendor will implement this interface; the
 * implemented object is the EJB object, which
 * delegates invocations to the actual bean.
 */
public interface UserManager extends EJBObject {
    
    /**
     * It uses the customer entity bean to crate a record in the databse
     */
    public void createUser(User user)throws RemoteException;
    
    /**
     * Returns an user object for the given customer id.
     * It uses customer entity bean to retrieve the user record.
     */
    public User getUser(String customerId) throws RemoteException;
    
    /**
     * Authenticate the user.
     */
    public boolean validateUser(String login, String password)throws InvalidPasswordException,RemoteException; 
}


