package examples;

import javax.ejb.*;
import java.rmi.RemoteException;
import java.util.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;

/**
 * UserManager is Stateless session bean resposible for creating and
 * retrieving a customer record.  It also authenticates the user.
 */

public class UserManagerBean 
    implements SessionBean 
{
    private static final String customerHomeName = "java:comp/env/ejb/CustomerHome";
    /*
     * Although this is a stateless session bean, we
     * do have state - the session context.  Remember
     * that stateless session beans can store state, they
     * just can't store state on behalf of particular
     * clients.
     */
    private SessionContext ctx;
       
    //----------------------------------------------------
    // Begin EJB-required methods.  The methods below are
    // called by the Container, and never called by client
    // code.
    //----------------------------------------------------
    
    /**
     * Returns an user object for the given customer id.
     * It uses customer entity bean to retrieve the user record.
     */
    public User getUser(String customerId) 
    {
        try
        {
            Context ctx = new InitialContext();
            CustomerHome customerHome = 
                (CustomerHome)PortableRemoteObject.narrow(
                    ctx.lookup(customerHomeName), CustomerHome.class);
            Customer customer = customerHome.findByPrimaryKey(customerId);

            return new User(customer.getCustomerID(),
                            customer.getName(),
                            customer.getPassword(),
                            customer.getAddress());
        }
        catch (Exception ex) 
        {
            throw new EJBException(ex);
        }
    }
        
    /**
     * It uses the customer entity bean to create a record in the databse
     */

    public void createUser(User user)
    {
        try
        {
            Context ctx = new InitialContext();
            CustomerHome customerHome = (CustomerHome)
                PortableRemoteObject.narrow(
                    ctx.lookup(customerHomeName),CustomerHome.class);
            Customer customer =
                customerHome.create(user.getCustomerID(),
                                    user.getName(),
                                    user.getPassword(),
                                    user.getAddress());
        }
        catch (Exception e) 
        {
            throw new EJBException(e);
        }
    }
    
    /**
     * This method authenticates the user
     *
     * @return true, if the password is correct
     * @throws an InvalidPasswordException if password is incorrect.
     */

    public boolean validateUser(String login, String password)
        throws InvalidPasswordException 
    {
        try
        {
            User user = getUser(login);
            if(password.equals(user.getPassword()))
            {
                return true;
            }
            else 
            {

                System.out.println("Failure to validate user " + login + 
                                   " with password " + password + 
                                   " against password " + user.getPassword());

                throw new InvalidPasswordException("Invalid Password:" + 
                                                   password);
            }
        }
        catch(Exception ex)
        {
            throw new EJBException(ex);
        }
    }
                
    //----------------------------------------------------
    // Begin EJB-required methods.  The methods below are
    // called by the Container, and never called by client
    // code.
    //----------------------------------------------------	
    public void ejbCreate() 
        throws RemoteException 
    {
        System.out.println("ejbCreate() called.");
    }
  
    public void ejbRemove() {
        System.out.println("ejbRemove() called.");
    }
    
    public void ejbActivate() {
        System.out.println("ejbActivate() called.");
    }
    
    public void ejbPassivate() {
        System.out.println("ejbPassivate() called.");
    }
    
    public void setSessionContext(SessionContext ctx) {
		System.out.println("setSessionContext() called");
		this.ctx = ctx;
    }
    
    //----------------------------------------------------
    // End EJB-required methods
    //----------------------------------------------------
}
