drop table customers;
drop table accounts;
drop table orders;
drop table products;
drop table orderLineItems;

create table accounts (
        id varchar(64), 
        ownername varchar(64), 
        balance numeric(18),
        CONSTRAINT PK_accounts PRIMARY KEY (id)  
);

create table customers (
        customerId varchar(64), 
        name varchar(64), 
        address varchar(64), 
        password varchar (64),
        CONSTRAINT PK_customers PRIMARY KEY (customerId)  
);

create table orders (
        orderId varchar(64), 
        customerId varchar(64), 
        orderDate timestamp, status varchar(64), 
        orderSubTotal numeric(18), 
        orderTaxes numeric(18),
        CONSTRAINT PK_orders PRIMARY KEY (orderId)  
        );

create table products (
        productId varchar(64), 
        name varchar(64), 
        basePrice numeric(18), 
        description varchar(64)
        CONSTRAINT PK_products PRIMARY KEY (productId)  
        );

create table orderLineItems( 
        id varchar(64),
        productId varchar(64), 
        orderId varchar(64),
        quantity int, 
        discount numeric(18),
        CONSTRAINT PK_orderLineItems PRIMARY KEY (id)  
        );


insert into customers values ('Ed Roman', 'Ed Roman', '12440 Alameda Trace Circle #1822 Austin TX 78727', 'password');
insert into customers values ('Rima Patel', 'Rima Patel', 'Boston MA', 'password');
insert into customers values ('Gerald Brose', 'Gerald Brose', 'Berlin, Germany', 'password');

insert into products values ('1', 'Athlon XP 2000', 800, 'AMD, entry-level');
insert into products values ('2', 'Celeron', 500, 'Intel 2.6 GHz, low-end machine');
insert into products values ('3', 'Pentium IV', 1000, 'Intel 3 GHz, 1024 MB, desktop');
insert into products values ('4', 'Power Mac G5', 3000, 'Apple, double processor');
insert into products values ('5', 'Xeon MP', 6000, 'Intel, 2GHz server machine');
insert into products values ('6', 'Athlon 64 3200', 1500, 'AMD Flagship');

