<%--
    This JSP displays details of the products added to the cart.
    The details includes the name of the product, quantity, base price,
    discount and total price of each line item. It also displays subtotal,
    taxes and grand total of the entire cart. Customer has provision to 
    modify the quantities, order the contents and clear the cart.
     
--%>
<HTML>
    <head><title> Jasmine's Shopping Cart page </title></head>
    <body>
        <jsp:include page="title.jsp" />
	<jsp:directive.page errorPage="error.jsp" />
        <%@ page import="examples.ProductItem" %>
        <%@ page import="examples.LineItem" %>
        <%@ page import="java.text.NumberFormat" %>
        <form action="/jasmine/showQuote" method="get"> 
                <center><table>
                    <tr>
			<th align=left> Name </TH>
			<th align=left> Quantity </TH>
			<th align=left> Individual Base Price </TH>
			<th align=left> Discount </TH>
			<th align=left><strong> Total Price </strong></TH>
			<th align=left>Modify Quantity</TH>
                    </tr>
                    <%
                    // get the lineItems from the request object and displays in a table format.
                    java.util.Enumeration lineItems = ((java.util.Vector) request.getAttribute("lineItems")).elements();
                    double subTotal=((Double)request.getAttribute("subTotal")).doubleValue();
                    double taxes=((Double)request.getAttribute("taxes")).doubleValue();
                    double total=((Double)request.getAttribute("total")).doubleValue();
   
                    while (lineItems.hasMoreElements()) {
                        LineItem li = (LineItem) lineItems.nextElement();
                        int quantity     = li.getQuantity();
                        double discount  = li.getDiscount();
                        ProductItem product  = li.getProductItem();
                        String productID = product.getProductID();
                        double basePrice = product.getBasePrice();
                    %>
                    <tr>
                        <td bgcolor="#ffffaa"><a href="/jasmine/catalog?productId=<%=product.getProductID()%>"><b><%=product.getName()%><b></td>
                        <td align="right" bgcolor="#ffffff"><%=quantity%></td>
                        <td bgcolor="#ffffaa" align="right"><%=NumberFormat.getCurrencyInstance().format(basePrice)%></td>
                        <td bgcolor="#ffffaa" align="right"><%=NumberFormat.getCurrencyInstance().format(discount)%></td>
                        <td bgcolor="#ffffaa" align="right"><%=NumberFormat.getCurrencyInstance().format((basePrice* quantity) - discount )%></td>
                        <td><input type="text" name="<%=productID%>" value="<%=quantity%>"></td>
                    </tr>
                    <% } %>
                </table></center>
                <br>
                <center><table>
                    <tr>
                        <td colspan="2" align="right" bgcolor="#ffffff"> Subtotal:</td>
                        <td bgcolor="#ffffaa" align="right"> <%=NumberFormat.getCurrencyInstance().format(subTotal)%></td>
                        <td> <br></td>          
                    </tr>
                    <tr>
                        <td colspan="2" align="right" bgcolor="#ffffff">Sales Tax: </td>
                        <td bgcolor="#ffffaa" align="right"><%=NumberFormat.getCurrencyInstance().format(taxes)%></td>
                        <td><br></td>
                    </tr>
                    <tr>
                        <td colspan="2" align="right" bgcolor="ffffff"> <font color="ff0000"> <strong>Grand Total:</strong></font> </td>
                        <td bgcolor="#ffffaa" align="right"><%=NumberFormat.getCurrencyInstance().format(total)%></td>
                        <td><br></td>   
                    </tr>
                </table></center>
                <!--
                    Print out links and buttons for user feedback.
                    When the customer clicks a button to perform an 
                    action (such as submitting an order), sends request to
		    the servlet with necessary parameters to process the request.
                //-->
                <p>
                <A href="/jasmine/catalog">See the Catalog</A>
                <input type="reset" value="Reset Values"> &nbsp; &nbsp; &nbsp;
                <input type="submit" name="Update" value="Update Quantities"> &nbsp; &nbsp; &nbsp;
                <input type="submit" name="Order" value="Submit Order"> &nbsp; &nbsp; &nbsp;
                <input type="submit" name="Clear" value="Clear Cart"> &nbsp; &nbsp; &nbsp;

        <jsp:include page="footer.jsp" />
        </form>
    </body>
</html>
