package examples;

import javax.ejb.*;

/**
 * Demonstration Stateful Session Bean.  This Bean is initialized
 * to some integer value, and has a business method which
 * increments the value.
 *
 * This example shows the basics of how to write a stateful
 * session bean, and how passivation/activation works.
 *
 */
public class CountBean implements SessionBean {
	
	// The current counter is our conversational state.
	public int val;

	//
	// Business methods
	//

	/**
	 * Counts up
	 */
	public int count() {
		System.out.println("count()");
		return ++val;
	}

	//
	// EJB-required methods
	//

	public void ejbCreate(int val) throws CreateException {
		this.val = val;
		System.out.println("ejbCreate()");
	}

	public void ejbRemove() {
		System.out.println("ejbRemove()");
	}

	public void ejbActivate() {
		System.out.println("ejbActivate()");
	}

	public void ejbPassivate() {
		System.out.println("ejbPassivate()");
	}

	public void setSessionContext(SessionContext ctx) {
		System.out.println("setSessionContext()");
	}
}
