package examples;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * This is the home interface for CountBean.  This interface
 * is implemented by the EJB Server's glue-code tools - the
 * implemented object is called the Home Object, and serves
 * as a factory for EJB Objects.
 * 
 * One create() method is in this Home Interface, which
 * corresponds to the ejbCreate() method in the CountBean file.
 */
public interface CountHome extends EJBHome {

   /*
    * This method creates the EJB Object.
    *
    * @param val Value to initialize counter to
    *
    * @return The newly created EJB Object.
    */
  Count create(int val) throws RemoteException, CreateException;
}
