package examples;

import java.net.URL;
import javax.xml.rpc.Service;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Stub;
import javax.xml.namespace.QName;

/**
 * This class is an example of a standalon JAX-RPC client code which 
 * uses both the static stub and the dynamic proxy approach to get
 * a reference to the remote Web Service
 */
public class HelloClient 
{
    static String host = "localhost";
    static String serviceURL = "HelloBean";    
    static String nameSpaceUri = "urn:examples";
    static String serviceName = "HelloWorldWS";    
    static String serviceEndpointAddress = "http://" + host + ":8080/" + serviceURL;

    public static void main(String[] args) 
        throws Exception 
    {        
        if( args.length == 2 )
        {
            host = args[0];
            serviceURL = args[1];
        }
        
        // the static stub approach
        HelloInterface hello = getStaticStub();
        System.out.println("Static stub: " + hello.hello());

        // the dynamic proxy approach

        // Specify the location of the WSDL file
        URL url = new URL(serviceEndpointAddress + "?WSDL");
        
        // Create an instance of service factory
        ServiceFactory serviceFactory = ServiceFactory.newInstance();
        
        // Create a service object to act as a factory for proxies.
        Service helloService = 
            serviceFactory.createService(url,
                                         new QName(nameSpaceUri, serviceName));

        hello =
            (examples.HelloInterface) helloService.getPort(examples.HelloInterface.class); 
                
        /*
         * Call the hello() method 
         */
        System.out.println("Dynamic proxy: " + hello.hello());



    }

    private static HelloInterface getStaticStub() 
    {
        Stub stub =
            (Stub)(new HelloWorldWS_Impl().getHelloInterfacePort());
        stub._setProperty(javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY,
                          serviceEndpointAddress);
        return (HelloInterface)stub;

    }
}
