package examples;

import java.net.URL;
import javax.xml.rpc.Service;
import javax.xml.rpc.JAXRPCException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceFactory;
import javax.naming.Context;
import javax.naming.InitialContext;

/**
 * This class is an example of client code which invokes
 * methods on a simple stateless session bean.
 */
public class HelloClientJNDI {

    public static void main(String[] args) 
        throws Exception 
    {        
        InitialContext ctx = new InitialContext();
        Service helloService = (Service)ctx.lookup("HelloWorldWS");

        HelloInterface hello =
            (examples.HelloInterface)helloService.getPort(examples.HelloInterface.class);               
        /*
         * Call the hello() method 
         */
        System.out.println(hello.hello());

    }
}
