package examples;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class CleanDayLimitOrdersClient {
     public static void main(String[] args) {
          try {

               Properties env = new Properties();
               env.put("java.naming.factory.initial","com.sun.jndi.cosnaming.CNCtxFactory");
               env.put("java.naming.provider.url", "iiop://localhost:3700");
               InitialContext ctxt = new InitialContext(env);

               Object objref = ctxt.lookup("CleanDayLimitOrdersBean");

               CleanDayLimitOrdersHome home = (CleanDayLimitOrdersHome) PortableRemoteObject.narrow(objref, CleanDayLimitOrdersHome.class);
		
               CleanDayLimitOrders cleanDayLimitOrders = home.create();
               cleanDayLimitOrders.cleanPeriodicallyDayLimitOrders();

		   System.out.println ("cleanPeriodicallyDayLimitOrders() returned successfully. Take a look at the application server log or console for messages from bean.");

               cleanDayLimitOrders.remove();
          } catch (Exception ex) {
               System.err.println("Caught an unexpected exception!");
               ex.printStackTrace();
          }
     } 
} 