/*
 * Decompiled with CFR 0.152.
 */
package examples.entity.intro;

import examples.entity.intro.Account;
import examples.entity.intro.AccountBean;
import examples.entity.intro.AccountManager;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Stateful
@Remote(value={AccountManager.class, Account.class})
public class AccountManagerBean
implements AccountManager,
Account {
    @PersistenceContext
    private EntityManager manager;
    private AccountBean account;

    public Account getAccount(int n) {
        if (this.account == null) {
            this.account = (AccountBean)this.manager.find(AccountBean.class, (Object)new Long(n));
        }
        if (this.account == null) {
            this.account = new AccountBean();
            this.manager.persist((Object)this.account);
        }
        return this;
    }

    public int getBalance() {
        if (this.account == null) {
            throw new IllegalStateException("Account Manager not initialized!");
        }
        return this.account.getBalance();
    }

    public void deposit(int n) {
        if (this.account == null) {
            throw new IllegalStateException("Account Manager not initialized!");
        }
        this.account.deposit(n);
    }

    public int withdraw(int n) {
        if (this.account == null) {
            throw new IllegalStateException("Account Manager not initialized!");
        }
        return this.account.withdraw(n);
    }

    public void remove(Account account) {
        this.manager.remove((Object)account);
    }
}

